<?php
include 'db.php';

// Check if the form was submitted and file is uploaded
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['image'])) {

    // Retrieve category data
    $categoryName = mysqli_real_escape_string($connection, $_POST['category']);
    $gmcCategory = mysqli_real_escape_string($connection, $_POST['gmccategory']);

    // Handle the uploaded image
    $image = $_FILES['image'];

    // Check if there were any errors during the upload
    if ($image['error'] !== UPLOAD_ERR_OK) {
        echo json_encode(["success" => false, "message" => "Image upload error: " . $image['error']]);
        exit;
    }

    $imageName = $image['name'];
    $imageTmpName = $image['tmp_name'];
    $imageSize = $image['size'];
    $imageExt = strtolower(pathinfo($imageName, PATHINFO_EXTENSION));
    $allowedExts = ['jpg', 'jpeg', 'png', 'gif'];

    // Check if the file extension is allowed
    if (!in_array($imageExt, $allowedExts)) {
        echo json_encode(["success" => false, "message" => "Invalid image format"]);
        exit;
    }

    // Create a unique name for the image
    $newImageName = uniqid('', true) . "." . $imageExt;
    $imageDestination = 'assests/images/category/' . $newImageName;

    // Attempt to move the uploaded file to the destination folder
    if (move_uploaded_file($imageTmpName, $imageDestination)) {
        // Insert category data into the database
        $deleteStatus = 0;  // 0 for active, 1 for deleted

        $sql = "INSERT INTO category (category, image, subcategory, subcategoryname, gmccategory, delete_status) 
                VALUES ('$categoryName', '$imageDestination', 0, '', '$gmcCategory', '$deleteStatus')";

        if (mysqli_query($connection, $sql)) {
            echo json_encode(["success" => true, "message" => "Category saved successfully"]);
        } else {
            echo json_encode(["success" => false, "message" => "Database insert failed: " . mysqli_error($connection)]);
        }
    } else {
        // Log specific error messages for failed image move
        echo json_encode(["success" => false, "message" => "Failed to upload image: " . error_get_last()['message']]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Invalid request or missing image"]);
}
?>
